---
title: Stable Diffusion 3 API Usage Guide
createdAt: Thu Jul 18 2024 06:09:30 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:41:12 GMT+0000 (Coordinated Universal Time)
---

# Stable Diffusion 3 API Usage Guide

## Introduction

This document will guide developers on how to use the aonweb library to call the Stable Diffusion 3 API for generating AI art images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
   input:{
        "cfg": 3.5,
        "prompt": "a photo of vibrant artistic graffiti on a wall saying \"SD3 medium\"",
        "aspect_ratio": "3:2",
        "output_format": "webp",
        "output_quality": 90,
        "negative_prompt": ""
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/stable-diffusion-3@stability-ai", data, price);
    // Handle response
} catch (error) {
    // Error handling
}
```


### Parameter Description

- `cfg`: Number, controls how closely the generated image adheres to the prompt. Higher values make the image more accurate but may reduce creativity.
- `prompt`: String, the text prompt describing the image you want to generate.
- `aspect_ratio`: String, specifies the aspect ratio of the output image, such as "3:2".
- `output_format`: String, specifies the format of the output image, here using "webp".
- `output_quality`: Number, specifies the quality of the output image, ranging from 0 to 100.
- `negative_prompt`: String, describes elements you do not want to appear in the generated image.

### Notes

- The quality and specificity of the prompt will directly affect the quality and accuracy of the generated image.
- The API may take some time to process the request and generate the image, consider implementing appropriate wait or loading states.
- Handle possible errors, such as network issues, invalid input, or API limitations.
- Adhere to the terms of use and copyright laws, especially in commercial use cases.

### Example Response

The API response will contain the URL of the generated image or other relevant information. Parse and use the response data according to the actual API documentation.
